<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>REKAPITULASI ABSENSI - <?php echo e($pembelajaran->kelas->name); ?> | <?php echo e($pembelajaran->mapel->name); ?></title>

    
    
    
    

    <style>
        .fs-12 {
            font-size: 12px;
        }

        .fs-11 {
            font-size: 11px;
        }

        .fs-14 {
            font-size: 14px;
        }
    </style>

    

</head>

<body style="font-family: 'Figtree';">

    <div>

        <div class="mt-0">

            <div class="text-center" style="text-align: center">
                <h3 class="fw-bold mb-1" style="margin-top: 0px; margin-bottom: 0px;">REKAPITULASI ABSENSI</h3>
                <h3 class="fw-bold" style="margin-top: 0px; margin-bottom: 0px;"><?php echo e($sekolah->name ?? ''); ?></h3>
                <p style="margin-top: 0px; margin-bottom: 0px;"><?php echo e($sekolah->alamat ?? ''); ?></p>
                <hr />
            </div>

            <div class="row my-3 mx-1">
                <b>Mata Pelajaran</b> : <?php echo e($pembelajaran->mapel->name); ?> <br>
                <b> Kelas</b> : <?php echo e($pembelajaran->kelas->name); ?> <br>
                <b> Guru Pengampu</b> : <?php echo e($pembelajaran->guru->name); ?> <br>
                <b> Tahun Pelajaran</b> : <?php echo e($pembelajaran->kelas->tapel->tahun_pelajaran); ?> - Semester
                <?php echo e($pembelajaran->kelas->tapel->semester); ?>

            </div>

            <hr>

            <div class="table-responsive">
                <table class="table table-sm table-striped table-hover table-bordered border-dark" border="1" cellspacing="0"  style="width: 100%">
                    <thead>
                        <tr class="bg-dark text-white">
                            <th scope="col" rowspan="2" class="border-dark text-center align-middle bg-info">#
                            </th>
                            <th scope="col" rowspan="2" class="border-dark text-center align-middle bg-info">NIS
                            </th>
                            <th scope="col" rowspan="2" class="border-dark text-center align-middle bg-info">Nama
                                Siswa</th>
                            <th scope="col" rowspan="2" class="border-dark text-center align-middle bg-info">L/P
                            </th>

                            <?php if($pertemuan->count() >= 1): ?>
                                <th scope="col" colspan="<?php echo e(count($pertemuan)); ?>"
                                    class="bg-info text-center border-dark">
                                    Pertemuan Ke</th>
                                <th scope="col" colspan="5" class="bg-info text-center border-dark">
                                    Jumlah</th>
                            <?php endif; ?>
                        </tr>
                        <tr class="bg-secondary">

                            <?php if($pertemuan->count() >= 1): ?>
                                <?php $__currentLoopData = $pertemuan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pert): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <th scope="col" class="border-dark" data-bs-toggle="modal">
                                        <div class="text-center align-middle"><?php echo e($pert->pertemuan_ke); ?>

                                        </div>

                                    </th>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <th class="bg-success border-dark align-middle text-center" data-bs-toggle="tooltip"
                                    data-bs-placement="top" title="Hadir">
                                    H
                                </th>
                                <th class="bg-primary border-dark align-middle text-center" data-bs-toggle="tooltip"
                                    data-bs-placement="top" title="Sakit">
                                    S
                                </th>
                                <th class="bg-purple border-dark align-middle text-center" data-bs-toggle="tooltip"
                                    data-bs-placement="top" title="Izin">
                                    I
                                </th>
                                <th class="bg-danger border-dark align-middle text-center" data-bs-toggle="tooltip"
                                    data-bs-placement="top" title="Alpa">
                                    A
                                </th>
                                <th class="bg-warning border-dark align-middle text-center" data-bs-toggle="tooltip"
                                    data-bs-placement="top" title="Terlambat">
                                    T
                                </th>
                            <?php endif; ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $siswa; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="border-dark"><?php echo e($loop->iteration); ?></td>
                                <td class="border-dark"><?php echo e($item->nis); ?></td>
                                <td class="border-dark text-uppercase"><?php echo e($item->name); ?></td>
                                <td class="border-dark"><?php echo e($item->jk); ?></td>

                                <?php if($pertemuan->count() >= 1): ?>
                                    <?php $__currentLoopData = $pertemuan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pert): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <td class="border-dark">
                                            <?php if($item->absen->where('siswa_id', $item->id)->where('pertemuan_id', $pert->id)->count() < 1): ?>
                                                <span class="badge bg-secondary px-2">Belum <br> Diinput</span>
                                            <?php else: ?>
                                                <?php if($item->absen->where('siswa_id', $item->id)->where('pertemuan_id', $pert->id)->first()->keterangan == 'H'): ?>
                                                    <span class="badge bg-success">
                                                        H
                                                    </span>
                                                <?php elseif($item->absen->where('siswa_id', $item->id)->where('pertemuan_id', $pert->id)->first()->keterangan == 'S'): ?>
                                                    <span class="badge bg-primary">
                                                        S
                                                    </span>
                                                <?php elseif($item->absen->where('siswa_id', $item->id)->where('pertemuan_id', $pert->id)->first()->keterangan == 'I'): ?>
                                                    <span class="badge bg-purple">
                                                        I
                                                    </span>
                                                <?php elseif($item->absen->where('siswa_id', $item->id)->where('pertemuan_id', $pert->id)->first()->keterangan == 'A'): ?>
                                                    <span class="badge bg-danger">
                                                        A
                                                    </span>
                                                <?php elseif($item->absen->where('siswa_id', $item->id)->where('pertemuan_id', $pert->id)->first()->keterangan == 'T'): ?>
                                                    <span class="badge bg-warning">
                                                        T
                                                    </span>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        </td>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    
                                    <td class="border-dark">
                                        <?php echo e($item->absen->where('keterangan', 'H')->whereIn('pertemuan_id', $pertemuan->pluck('id'))->count() < 1? '': $item->absen->where('keterangan', 'H')->whereIn('pertemuan_id', $pertemuan->pluck('id'))->count()); ?>

                                    </td>
                                    <td class="border-dark">
                                        <?php echo e($item->absen->where('keterangan', 'S')->whereIn('pertemuan_id', $pertemuan->pluck('id'))->count() < 1? '': $item->absen->where('keterangan', 'S')->whereIn('pertemuan_id', $pertemuan->pluck('id'))->count()); ?>

                                    </td>
                                    <td class="border-dark">
                                        <?php echo e($item->absen->where('keterangan', 'I')->whereIn('pertemuan_id', $pertemuan->pluck('id'))->count() < 1? '': $item->absen->where('keterangan', 'I')->whereIn('pertemuan_id', $pertemuan->pluck('id'))->count()); ?>

                                    </td>
                                    <td class="border-dark">
                                        <?php echo e($item->absen->where('keterangan', 'A')->whereIn('pertemuan_id', $pertemuan->pluck('id'))->count() < 1? '': $item->absen->where('keterangan', 'A')->whereIn('pertemuan_id', $pertemuan->pluck('id'))->count()); ?>

                                    </td>
                                    <td class="border-dark">
                                        <?php echo e($item->absen->where('keterangan', 'T')->whereIn('pertemuan_id', $pertemuan->pluck('id'))->count() < 1? '': $item->absen->where('keterangan', 'T')->whereIn('pertemuan_id', $pertemuan->pluck('id'))->count()); ?>

                                    </td>
                                    
                                <?php endif; ?>

                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

        </div>

</body>

</html>
<?php /**PATH D:\project\zahra_absensi\resources\views/pages/rekapabsensi/print2.blade.php ENDPATH**/ ?>