

<?php $__env->startSection('content'); ?>

    <div class="content-header">
        <div class="container-fluid">

          <div class="row">
            <div class="col-sm-6">
              <h1 class="m-0">Data Pembelajaran <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('gurumapel')): ?> Saya <?php endif; ?></h1>
            </div>
            <div class="col-sm-6">
                <?php if(session()->has('info')): ?>
                    <div class="alert alert-success alert-dismissible fade show mb-0" role="alert">
                        <?php echo $__env->make('_success', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php echo session('info'); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>

        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">

                          <div class="callout callout-warning my-1">
                            <div class="row col-md-6">
                              <div class="col-md-4 fw-bold">
                                Mata Pelajaran
                              </div>
                              <div class="col-md-8">
                                : <?php echo e($pembelajaran->mapel->name); ?>

                              </div>
                              <div class="col-md-4 fw-bold">
                                Kelas
                              </div>
                              <div class="col-md-8">
                               :  <?php echo e($pembelajaran->kelas->name); ?>

                              </div>
                              <div class="col-md-4 fw-bold">
                                KKM
                              </div>
                              <div class="col-md-8">
                               :  <?php echo e($pembelajaran->kkm); ?>

                              </div>
                              <div class="col-md-4 fw-bold">
                                Guru Pengampu
                              </div>
                              <div class="col-md-8">
                               :  <?php echo e($pembelajaran->guru->name); ?><?php echo e($pembelajaran->guru->gelar ? ', ' . $pembelajaran->guru->gelar : ''); ?>

                              </div>
                              <div class="col-md-4 fw-bold">
                                Tahun Pelajaran
                              </div>
                              <div class="col-md-8">
                               :  <?php echo e($pembelajaran->mapel->tapel->tahun_pelajaran); ?> - Semester <?php echo e($pembelajaran->mapel->tapel->semester); ?>

                              </div>
                            </div>
                          </div>

                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <?php if(count($siswa) < 1): ?>
                                Belum ada Siswa di Pembelajaran ini.
                            <?php else: ?>
                                <div class="table-responsive">
                                    <form action="<?php echo e(route('datapembelajaran.insertnilai', $pembelajaran->id)); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('PUT'); ?>
                                        <table id="" class="table table-sm table-hover">
                                            <thead>
                                                <tr class="bg-dark text-white">
                                                    <th scope="col">#</th>
                                                    <th scope="col">NIS</th>
                                                    <th scope="col">Nama</th>
                                                    <th scope="col">Nilai Pengetahuan</th>
                                                    <th scope="col">Nilai Keterampilan</th>
                                                    <th scope="col">Nilai PTS</th>
                                                    <th scope="col">Nilai PAS</th>
                                                    <th scope="col">Rata-Rata</th>
                                                    <th scope="col">Deskripsi</th>
                                                </tr>
                                            </thead>
                                            <tbody>

                                                <?php $__currentLoopData = $siswa; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td><?php echo e($loop->iteration); ?></td>
                                                        <td><?php echo e($item->nis); ?></td>
                                                        <td style="max-width: 300px" class="text-uppercase">
                                                            <?php echo e($item->name); ?></td>
                                                        <td>
                                                            <input type="hidden" name="siswa_id[]" value="<?php echo e($item->id); ?>">
                                                            <input type="number" class="form-control input-nilai"
                                                                name="nilai_pengetahuans[]" id="nilai_pengetahuans"
                                                                value="<?php echo e($nilaiPengetahuan->where('siswa_id', $item->id)->first() ? $nilaiPengetahuan->where('siswa_id', $item->id)->first()->nilai : ''); ?>">
                                                        </td>
                                                        <td>
                                                            <input type="number" class="form-control input-nilai"
                                                                name="nilai_keterampilans[]" id="nilai_keterampilans"
                                                                value="<?php echo e($nilaiKeterampilan->where('siswa_id', $item->id)->first() ? $nilaiKeterampilan->where('siswa_id', $item->id)->first()->nilai : ''); ?>">
                                                        </td>
                                                        <td>
                                                            <input type="number" class="form-control input-nilai"
                                                                name="nilai_pts[]" id="nilai_pts"
                                                                value="<?php echo e($nilaiPts->where('siswa_id', $item->id)->first() ? $nilaiPts->where('siswa_id', $item->id)->first()->nilai : ''); ?>">
                                                        </td>
                                                        <td>
                                                            <input type="number" class="form-control input-nilai"
                                                                name="nilai_pas[]" id="nilai_pas"
                                                                value="<?php echo e($nilaiPas->where('siswa_id', $item->id)->first() ? $nilaiPas->where('siswa_id', $item->id)->first()->nilai : ''); ?>">
                                                        </td>
                                                        <td class="rataRata fw-bold">

                                                        </td>
                                                        <td>
                                                          <textarea name="deskripsi[]" class="form-control" id="" cols="30" rows="5"><?php echo e($nilaiAkhir->where('siswa_id', $item->id)->first() ? $nilaiAkhir->where('siswa_id', $item->id)->first()->deskripsi : ''); ?></textarea>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                            </tbody>
                                        </table>
                                        <button type="submit" class="btn btn-success float-right">
                                            Simpan
                                        </button>
                                        <div class="checkbox float-right me-3">
                                            <label>
                                                <input type="checkbox" class="mt-3" required>
                                                Saya yakin akan mengubah data tersebut
                                            </label>
                                        </div>
                                    </form>
                                </div>

                                <script src="/my-js/jquery.js"></script>
                                <script>
                                    $(document).ready(function() {
                                        function hitungRataRata() {
                                            $(".rataRata").each(function() {
                                                var row = $(this).closest("tr");
                                                var nilaiPengetahuan = parseFloat(row.find("input[name='nilai_pengetahuans[]']")
                                                .val()) || 0;
                                                var nilaiKeterampilan = parseFloat(row.find("input[name='nilai_keterampilans[]']")
                                                .val()) || 0;
                                                var nilaiPTS = parseFloat(row.find("input[name='nilai_pts[]']").val()) || 0;
                                                var nilaiPAS = parseFloat(row.find("input[name='nilai_pas[]']").val()) || 0;

                                                var rataRata = (nilaiPengetahuan + nilaiKeterampilan + nilaiPTS + nilaiPAS) / 4;

                                                $(this).text(rataRata.toFixed(2));
                                            });
                                        }

                                        $(document).on("input", ".input-nilai", function() {
                                            hitungRataRata();
                                        });

                                        hitungRataRata();
                                    });
                                </script>
                            <?php endif; ?>
                        </div>
                        <!-- /.card-body -->
                    </div>
                </div>
            </div>

        </div>
    </section>

    
    
    <div class="modal fade text-black" id="petunjukAksi" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title fw-bold" id="exampleModalLabel">Petunjuk Aksi</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body fs-xs-14">
                    <table class="table table-borderless table-sm m-0">
                        <?php echo $__env->make('petunjuk.add', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php echo $__env->make('petunjuk.show', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php echo $__env->make('petunjuk.edit', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php echo $__env->make('petunjuk.delete', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </table>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-primary" data-bs-dismiss="modal">Oke</button>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\project\zahra_absensi\resources\views/pages/datapembelajaran/show.blade.php ENDPATH**/ ?>