<?php
    use App\Models\HariLibur;
    use Carbon\Carbon;
?>



<?php $__env->startSection('content'); ?>
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-0">
                <div class="col-sm-6">
                    <h4 class="fw-bold poppins m-0 text-xs-center mt-xs-2">Dashboard</h4>
                </div>
                <div class="col-sm-6 mt-xs-2">
                    <?php if(session()->has('success')): ?>
                        <div class="alert alert-success alert-dismissible fade show mb-0" role="alert">
                            <?php echo $__env->make('_success', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php echo e(session('success')); ?>

                        </div>
                    <?php endif; ?>

                    <?php if(session()->has('login')): ?>
                        <div class="alert alert-info alert-dismissible fade show mb-0" role="alert">
                            <?php echo $__env->make('_success', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            Anda berhasil login sebagai <b class="text-uppercase"> <?php echo e(session('login')); ?> </b>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
              <?php if(auth()->user()->role == 'admin' || auth()->user()->role == 'guru'): ?>
                <div class="col-md-3 col-sm-4 col-6">
                    <div class="small-box bg-primary">
                        <div class="inner">
                            <h3><?php echo e($siswa); ?></h3>
                            <p>Data Siswa</p>
                        </div>
                        <div class="icon">
                          <i class="ion ion-person-stalker"></i>
                        </div>
                        <a href="<?php echo e(route('datasiswa.index', $role)); ?>" class="small-box-footer">Lihat detail
                            <i class="fas fa-arrow-circle-right"></i>
                        </a>
                    </div>
                </div>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('admin')): ?>
                <div class="col-md-3 col-sm-4 col-6">
                    <div class="small-box bg-success">
                        <div class="inner">
                            <h3><?php echo e($guru); ?></h3>
                            <p>Data Guru</p>
                        </div>
                        <div class="icon">
                          <i class="ion ion-person-stalker"></i>
                        </div>
                        <a href="<?php echo e(route('dataguru.index', $role)); ?>" class="small-box-footer">Lihat detail
                            <i class="fas fa-arrow-circle-right"></i>
                        </a>
                    </div>
                </div>
                <div class="col-md-3 col-sm-4 col-6">
                    <div class="small-box bg-warning">
                        <div class="inner">
                            <h3><?php echo e($admin); ?></h3>
                            <p>Data Admin</p>
                        </div>
                        <div class="icon">
                            <i class="ion ion-person"></i>
                        </div>
                        <a href="<?php echo e(route('dataadmin.index', $role)); ?>" class="small-box-footer">Lihat detail
                            <i class="fas fa-arrow-circle-right"></i>
                        </a>
                    </div>
                </div>
                <div class="col-md-3 col-sm-4 col-6">
                    <div class="small-box bg-danger">
                        <div class="inner">
                            <h3><?php echo e($kelas); ?></h3>
                            <p>Data Kelas</p>
                        </div>
                        <div class="icon">
                          <i class="ion ion-log-in"></i>
                        </div>
                        <a href="<?php echo e(route('datakelas.index', $role)); ?>" class="small-box-footer">Lihat detail
                            <i class="fas fa-arrow-circle-right"></i>
                        </a>
                    </div>
                </div>
                <div class="col-md-3 col-sm-4 col-6">
                    <div class="small-box bg-info">
                        <div class="inner">
                            <h3><?php echo e($tapel); ?></h3>
                            <p>Data Tahun Pelajaran</p>
                        </div>
                        <div class="icon">
                          <i class="ion ion-stats-bars"></i>
                        </div>
                        <a href="<?php echo e(route('datatapel.index', $role)); ?>" class="small-box-footer">Lihat detail
                            <i class="fas fa-arrow-circle-right"></i>
                        </a>
                    </div>
                </div>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('siswa')): ?>
                <div class="col-md-3 col-sm-4 col-6">
                    <div class="small-box bg-success">
                        <div class="inner">
                            <h3>Absensi</h3>
                            <p>Kehadiran Saya</p>
                        </div>
                        <div class="icon">
                            <i class="ion ion-file"></i>
                        </div>
                        <a href="<?php echo e(route('absensi.show', [$role, Auth::user()->siswa->kelas_id])); ?>" class="small-box-footer">Lihat detail
                            <i class="fas fa-arrow-circle-right"></i>
                        </a>
                    </div>
                </div>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('walikelas')): ?>
                  <div class="col-md-3 col-sm-4 col-6">
                      <div class="small-box bg-success">
                          <div class="inner">
                              <h3>Absensi</h3>
                              <p>Kehadiran Kelas Saya</p>
                          </div>
                          <div class="icon">
                              <i class="ion ion-file"></i>
                          </div>
                          <a href="<?php echo e(route('absensi.show', [$role, Auth::user()->guru->kelas->id])); ?>" class="small-box-footer">Lihat detail
                              <i class="fas fa-arrow-circle-right"></i>
                          </a>
                      </div>
                  </div>

                <?php

                  $role = Auth::user()->role;
                  $date = date('Y-m-d');
                  $month = Carbon::now()->format('m');

                  $dateString = $date;
                  list($year, $month, $day) = explode('-', $dateString);
                  $timestamp = mktime(0, 0, 0, $month, $day, $year);
                  $timestamp = strtotime($dateString);

                  $key = $timestamp . '_' . Str::random(10);

                  $hariLibur = HariLibur::get()->pluck('tgl');
                  $akhirPekan = Carbon::parse($date);

                ?>

                  <?php if($hariLibur->contains($date) || $akhirPekan->dayOfWeek === 0 || $akhirPekan->dayOfWeek == 6): ?>
                  
                  <?php else: ?>
                    <div class="col-md-3 col-sm-4 col-6">
                        <div class="small-box bg-warning">
                            <div class="inner">
                                <h3>Input</h3>
                                <p>Absen Hari Ini</p>
                            </div>
                            <div class="icon">
                                <i class="ion ion-file"></i>
                            </div>
                            <a href="<?php echo e(route('absensi.kelas.day.get', [Auth::user()->role,  Auth::user()->guru->kelas->id, $month, $date, $key])); ?>" class="small-box-footer">Lihat detail
                                <i class="fas fa-arrow-circle-right"></i>
                            </a>
                        </div>
                    </div>
                  <?php endif; ?>

                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('piket')): ?>
                <div class="col-md-3 col-sm-4 col-6">
                    <div class="small-box bg-success">
                        <div class="inner">
                            <h3>Absensi</h3>
                            <p>Kehadiran</p>
                        </div>
                        <div class="icon">
                            <i class="ion ion-file"></i>
                        </div>
                        <a href="<?php echo e(route('absensi.index', $role)); ?>" class="small-box-footer">Lihat detail
                            <i class="fas fa-arrow-circle-right"></i>
                        </a>
                    </div>
                </div>
                <?php endif; ?>

                <div class="col-md-3 col-sm-4 col-6">
                    <div class="small-box bg-cyan">
                        <div class="inner">
                            <h3>Profil</h3>
                            <p>Profil Saya</p>
                        </div>
                        <div class="icon">
                            <i class="ion ion-person"></i>
                        </div>
                        <a href="<?php echo e('/' . auth()->user()->role . '/profil'); ?>" class="small-box-footer">Lihat detail
                            <i class="fas fa-arrow-circle-right"></i>
                        </a>
                    </div>
                </div>

            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\project\smkn54kjt_absensi\resources\views/pages/dashboard/index.blade.php ENDPATH**/ ?>