<?php
    use Carbon\Carbon;
    use App\Models\Absen;
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>REKAPITULASI ABSENSI PER-TINGKAT</title>

    <style>
        .fs-12 {
            font-size: 12px;
        }

        .fs-11 {
            font-size: 11px;
        }

        .fs-14 {
            font-size: 14px;
        }
    </style>

</head>

<body style="font-family: 'Times New Roman';  font-size: 14px"">

    <div>

        <div class="mt-0">
            <div class="text-center" style="text-align: center">
                <h3 class="fw-bold mb-1" style="margin-top: 0px; margin-bottom: 0px;">REKAPITULASI ABSENSI</h3>
                <h3 class="fw-bold" style="margin-top: 0px; margin-bottom: 0px;"><?php echo e($sekolah->name ?? ''); ?></h3>
                <p style="margin-top: 0px; margin-bottom: 0px; "><?php echo e($sekolah->alamat ?? ''); ?></p>
                <hr />
            </div>

            <div class="">
              <table border="0" cellspacing="1">
                  <td style="font-weight: bold">Periode Absen</td>
                  <td>:</td>
                  <td><?php echo e($periode); ?></td>
                </tr>
              </table>
            </div>

            <hr>

            <div class="table-responsive">
              <table class="table table-sm table-hover table-bordered border-dark" border="1" cellspacing="0"  style="width: 100%">

                <thead>
                  <tr class="border-dark">
                    <th class="border-dark text-center align-middle bg-info" rowspan="2">#</th>
                    <th class="border-dark text-center align-middle bg-info" rowspan="2" style="min-width: 200px">Tingkat</th>
                    <th class="border-dark text-center align-middle bg-info" colspan="4">Jumlah</th>
                  </tr>
                  <tr class="bg-secondary">
                    <th class="bg-success border-dark align-middle text-center" style="min-width: 30px">H</th>
                    <th class="bg-primary border-dark align-middle text-center" style="min-width: 30px">S</th>
                    <th class="bg-warning border-dark align-middle text-center" style="min-width: 30px">I</th>
                    <th class="bg-danger border-dark align-middle text-center" style="min-width: 30px">A</th>
                  </tr>
                </thead>
                <tbody>
                  <?php $__currentLoopData = $tingkat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <tr class="border-dark">
                        <td class="border-dark"><?php echo e($loop->iteration); ?></td>
                        <td class="border-dark">Kelas <?php echo e($item['int']); ?> <?php echo e('(' . $item['str'] . ')'); ?></td>

                        <?php
                            $absenModel = new Absen();
                            $H = $absenModel->hitungJumlahAbsenPerTingkat($item['int'], $tglAwal, $tglAkhir, 'H');
                            $S = $absenModel->hitungJumlahAbsenPerTingkat($item['int'], $tglAwal, $tglAkhir, 'S');
                            $I = $absenModel->hitungJumlahAbsenPerTingkat($item['int'], $tglAwal, $tglAkhir, 'I');
                            $A = $absenModel->hitungJumlahAbsenPerTingkat($item['int'], $tglAwal, $tglAkhir, 'A');
                        ?>

                        <td class="border-dark" style="text-align: center"><?php echo e($H > 0 ? $H : ''); ?></td>
                        <td class="border-dark" style="text-align: center"><?php echo e($S > 0 ? $S : ''); ?></td>
                        <td class="border-dark" style="text-align: center"><?php echo e($I > 0 ? $I : ''); ?></td>
                        <td class="border-dark" style="text-align: center"><?php echo e($A > 0 ? $A : ''); ?></td>
                      </tr>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>

              </table>
            </div>

        </div>

</body>

</html>
<?php /**PATH D:\project\absensi_walikelas\resources\views/pages/rekapabsensi/perangkatan/print.blade.php ENDPATH**/ ?>