<?php
    use Carbon\Carbon;
    use Illuminate\Support\Str;
?>

<?php $__env->startSection('css'); ?>
  <style>
    .vertical {
      transform: rotate(180deg);
    }

    .bg-H {
        background-color: #28a745
    }

    .bg-S {
      background-color:#007bff
    }

    .bg-I{
      background-color: #ffc107
    }

    .bg-A{
      background-color: #dc3545
    }
  </style>
<?php $__env->stopSection(); ?>



<?php $__env->startSection('content'); ?>
    <div class="content-header">
        <div class="container-fluid">

            <div class="row mb-0">
                <div class="col-sm-6">
                    <h4 class="fw-bold poppins m-0">
                      <a href="<?php echo e(route('absensi.show', [auth()->user()->role, $kelas->id])); ?>" class="btn btn-sm btn-link p-0 me-1">
                        <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" fill="currentColor"
                            class="bi fw-bold bi-arrow-left" viewBox="0 0 16 16">
                            <path fill-rule="evenodd"
                                d="M15 8a.5.5 0 0 0-.5-.5H2.707l3.147-3.146a.5.5 0 1 0-.708-.708l-4 4a.5.5 0 0 0 0 .708l4 4a.5.5 0 0 0 .708-.708L2.707 8.5H14.5A.5.5 0 0 0 15 8z" />
                        </svg>
                    </a>
                      Absensi: <?php echo e($kelas->name); ?>

                    </h4>
                </div>
                <div class="col-sm-6 mt-xs-2">
                    <?php if(session()->has('success')): ?>
                        <div class="alert alert-success alert-dismissible fade show mb-0" role="alert">
                            <?php echo $__env->make('_success', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php echo session('success'); ?>

                        </div>
                    <?php endif; ?>
                </div>
            </div>

        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-header">

                          <div class="callout callout-warning my-1">
                              <div class="row">
                                  <div class="col">
                                      <div class="row">
                                        <div class="table-responsive">
                                          <table class="table-borderless">
                                            <tr>
                                              <td class="fw-bold">Kelas</td>
                                              <td style="width: 1px" class="px-2">:</td>
                                              <td><?php echo e($kelas->name); ?></td>
                                            </tr>
                                            <tr>
                                              <td class="fw-bold">Wali Kelas</td>
                                              <td style="width: 1px" class="px-2">:</td>
                                              <td><?php echo e($kelas->guru->name); ?></td>
                                            </tr>
                                            <tr>
                                              <td class="fw-bold">Tahun Pelajaran</td>
                                              <td style="width: 1px" class="px-2">:</td>
                                              <td><?php echo e($kelas->tapel->tahun_pelajaran); ?> - Semester <?php echo e($kelas->tapel->semester); ?></td>
                                            </tr>
                                            <tr>
                                              <td class="fw-bold">Bulan</td>
                                              <td style="width: 1px" class="px-2">:</td>
                                              <td><?php echo e($monthIndo); ?></td>
                                            </tr>
                                          </table>
                                        </div>

                                      </div>
                                  </div>
                              </div>
                          </div>

                        </div>

                        <div class="card-body">

                          <div class="table-responsive">
                            <table class="table table-sm table-hover table-bordered border-dark">

                              <thead>
                                <tr class="border-dark">
                                  <th class="border-dark text-center align-middle bg-info" rowspan="2">#</th>
                                  <th class="border-dark text-center align-middle bg-info" rowspan="2" style="min-width: 200px">Nama Siswa</th>
                                  <th class="border-dark text-center align-middle bg-info" rowspan="2">NIS</th>
                                  <th class="border-dark text-center align-middle bg-info" rowspan="2">L/P</th>
                                  <th class="border-dark text-center align-middle bg-info" colspan="<?php echo e(count($months)); ?>">Tanggal</th>
                                  <th class="border-dark text-center align-middle bg-info" colspan="4" >Jumlah</th>
                                </tr>
                                <tr class="bg-secondary">
                                  <?php $__currentLoopData = $months; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $date): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if(Str::before(Carbon::parse($date)->locale('id_ID')->isoFormat('dddd, D MMMM Y'), ',') == 'Sabtu' || Str::before(Carbon::parse($date)->locale('id_ID')->isoFormat('dddd, D MMMM Y'), ',') == 'Minggu'): ?>
                                      <th class="border-dark text-center bg-danger" data-bs-toggle="tooltip"
                                        data-bs-placement="top" title="<?php echo e(Carbon::parse($date)->locale('id_ID')->isoFormat('dddd, D MMMM Y')); ?>">
                                        <?php echo e(Str::afterLast($date, '-')); ?>

                                      </th>
                                    <?php elseif($libur->pluck('tgl')->contains($date)): ?>
                                      <th class="border-dark text-center bg-danger" data-bs-toggle="tooltip"
                                        data-bs-placement="top" title="<?php echo e(Carbon::parse($date)->locale('id_ID')->isoFormat('dddd, D MMMM Y')); ?>">
                                        <?php echo e(Str::afterLast($date, '-')); ?>

                                      </th>
                                    <?php else: ?>
                                      <th class="border-dark text-center" data-bs-toggle="tooltip"
                                        data-bs-placement="top" title="<?php echo e(Carbon::parse($date)->locale('id_ID')->isoFormat('dddd, D MMMM Y')); ?>">

                                        <?php
                                            $dateString = $date;
                                            list($year, $month, $day) = explode('-', $dateString);

                                            // Mengubah ke format UNIX timestamp menggunakan mktime()
                                            $timestamp = mktime(0, 0, 0, $month, $day, $year);

                                            // Atau, Anda juga bisa menggunakan strtotime()
                                            $timestamp = strtotime($dateString);
                                            $key = $timestamp . '_' . Str::random(10);
                                        ?>

                                        <?php if(Auth::user()->role == 'siswa'): ?>
                                          <?php echo e(Str::afterLast($date, '-')); ?>

                                        <?php else: ?>
                                        <a href="<?php echo e(route('absensi.kelas.day.get', [$role,  $kelas->id, $month, $date, $key])); ?>" class="text-white">
                                          <?php echo e(Str::afterLast($date, '-')); ?>

                                        </a>
                                          <?php endif; ?>
                                      </th>
                                    <?php endif; ?>
                                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                  <th class="bg-success border-dark align-middle text-center" style="min-width: 30px">H</th>
                                  <th class="bg-primary border-dark align-middle text-center" style="min-width: 30px">S</th>
                                  <th class="bg-warning border-dark align-middle text-center" style="min-width: 30px">I</th>
                                  <th class="bg-danger border-dark align-middle text-center" style="min-width: 30px">A</th>
                                </tr>
                              </thead>
                              <tbody>
                                <?php $__currentLoopData = $siswa; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="border-dark">
                                      <td class="border-dark"><?php echo e($loop->iteration); ?></td>
                                      <td class="border-dark"><?php echo e($item->name); ?></td>
                                      <td class="border-dark"><?php echo e($item->nis); ?></td>
                                      <td class="border-dark"><?php echo e($item->jk); ?></td>

                                      

                                      <?php $__currentLoopData = $months; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $date): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                          <?php if(Carbon::parse($date)->isoFormat('dddd') == 'Sabtu' || Carbon::parse($date)->isoFormat('dddd') == 'Minggu'): ?>
                                              <td class="border-dark bg-danger" data-bs-toggle="tooltip" data-bs-placement="top" title="Libur Hari <?php echo e(Carbon::parse($date)->isoFormat('dddd') == 'Sabtu' ? 'Sabtu' : 'Minggu'); ?>">

                                              </td>
                                          <?php elseif($libur->pluck('tgl')->contains($date)): ?>
                                              <td class="border-dark bg-danger" data-bs-toggle="tooltip" data-bs-placement="top" title="<?php echo e($libur->where('tgl', $date)->first()->ket); ?>">

                                              </td>
                                          <?php elseif(!in_array($date, $absenDiTglIni->toArray())): ?>
                                            <td class="border-dark text-center align-middle">
                                                ?
                                            </td>
                                          <?php elseif($absen->where('siswa_id', $item->id)->where('tanggal', $date)->count() < 1): ?>
                                              <td class="border-dark text-center align-middle">
                                                  <span class="badge bg-success">
                                                   H
                                                  </span>
                                              </td>
                                          <?php else: ?>
                                              <td class="border-dark text-center align-middle">
                                                  <span class="badge bg-<?php echo e($absen->where('siswa_id', $item->id)->where('tanggal', $date)->first()->keterangan); ?>">
                                                    <?php echo e($absen->where('siswa_id', $item->id)->where('tanggal', $date)->first()->keterangan); ?>

                                                  </span>
                                              </td>
                                          <?php endif; ?>
                                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                      <?php
                                           $H = $absen->where('siswa_id', $item->id)
                                                      ->whereIn('keterangan', ['H'])
                                                      ->where('tanggal', '>=', $months[0])
                                                      ->where('tanggal', '<=', end($months))
                                                      ->whereNotIn('tanggal', $libur->pluck('tgl'))
                                                      ->count();

                                           $S = $absen->where('siswa_id', $item->id)
                                                      ->whereIn('keterangan', ['S'])
                                                      ->where('tanggal', '>=', $months[0])
                                                      ->where('tanggal', '<=', end($months))
                                                      ->whereNotIn('tanggal', $libur->pluck('tgl'))
                                                      ->count();

                                           $I = $absen->where('siswa_id', $item->id)
                                                      ->whereIn('keterangan', ['I'])
                                                      ->where('tanggal', '>=', $months[0])
                                                      ->where('tanggal', '<=', end($months))
                                                      ->whereNotIn('tanggal', $libur->pluck('tgl'))
                                                      ->count();

                                           $A = $absen->where('siswa_id', $item->id)
                                                      ->whereIn('keterangan', ['A'])
                                                      ->where('tanggal', '>=', $months[0])
                                                      ->where('tanggal', '<=', end($months))
                                                      ->whereNotIn('tanggal', $libur->pluck('tgl'))
                                                      ->count();

                                          $jmlTidakHadir = $S + $I + $A;

                                      ?>

                                      <td class="border-dark text-center"><?php echo e($absenDiTglIni->count() - $jmlTidakHadir == '0' ? '' : $absenDiTglIni->count() - $jmlTidakHadir); ?></td>
                                      <td class="border-dark text-center"><?php echo e($S > 0 ? $S : ''); ?></td>
                                      <td class="border-dark text-center"><?php echo e($I > 0 ? $I : ''); ?></td>
                                      <td class="border-dark text-center"><?php echo e($A > 0 ? $A : ''); ?></td>

                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                              </tbody>

                            </table>
                          </div>

                        </div>

                    </div>
                </div>
            </div>
        </div>

        </div>
    </section>

    <script>
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
        var tooltipList = tooltipTriggerList.map(function(tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl)
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\project\absensi_walikelas\resources\views/pages/absensi/showmonth.blade.php ENDPATH**/ ?>