<?php
    use Carbon\Carbon;
    use Carbon\CarbonInterface;
?>



<?php $__env->startSection('content'); ?>
    <div class="content-header">
        <div class="container-fluid">

            <div class="row mb-0">
                <div class="col-sm-6">
                    <h4 class="fw-bold poppins m-0">
                        <a href="<?php echo e(route('absensi.kelas.month', [$role, $kelas->id, $month])); ?>" class="btn btn-sm btn-link p-0 me-1" >
                            <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" fill="currentColor"
                                class="bi fw-bold bi-arrow-left" viewBox="0 0 16 16">
                                <path fill-rule="evenodd"
                                    d="M15 8a.5.5 0 0 0-.5-.5H2.707l3.147-3.146a.5.5 0 1 0-.708-.708l-4 4a.5.5 0 0 0 0 .708l4 4a.5.5 0 0 0 .708-.708L2.707 8.5H14.5A.5.5 0 0 0 15 8z" />
                            </svg>
                        </a>
                        Kelola Absensi: <?php echo e($kelas->name); ?>

                    </h4>
                </div>
                <div class="col-sm-6">
                  <?php if(session()->has('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show mb-0" role="alert">
                        <?php echo $__env->make('_success', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php echo session('success'); ?>

                    </div>
                  <?php endif; ?>
                  <?php if(session()->has('failed')): ?>
                    <div class="alert alert-danger alert-dismissible fade show mb-0" role="alert">
                        <?php echo $__env->make('_failed', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php echo session('failed'); ?>

                    </div>
                  <?php endif; ?>
                </div>
            </div>

        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                      <div class="card-header">

                        <div class="callout callout-warning my-1">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="row">
                                        <div class="col-md-4 fw-bold">
                                            Kelas
                                        </div>
                                        <div class="col-md-8">
                                            : <?php echo e($kelas->name); ?>

                                        </div>
                                        <div class="col-md-4 fw-bold">
                                            Wali Kelas
                                        </div>
                                        <div class="col-md-8">
                                            : <?php echo e($kelas->guru->name); ?>

                                        </div>
                                        <div class="col-md-4 fw-bold">
                                            Tahun Pelajaran
                                        </div>
                                        <div class="col-md-8">
                                            : <?php echo e($kelas->tapel->tahun_pelajaran); ?> - Semester
                                            <?php echo e($kelas->tapel->semester); ?>

                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                  <div class="row">
                                    <div class="col-md-4 fw-bold">
                                        Hari, Tanggal
                                    </div>
                                    <div class="col-md-8">
                                        : <?php echo e(Carbon::parse($date)->locale('id_ID')->isoFormat('dddd, D MMMM Y')); ?>

                                    </div>
                                  </div>
                                </div>
                            </div>
                        </div>
                    </div>

                        <!-- /.card-header -->
                        <div class="card-body">
                            <?php if($siswa->count() < 1): ?>
                                Belum ada Siswa di Kelas Ini!
                            <?php else: ?>
                                <div class="table-responsive">
                                  <form action="#" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>
                                    <table id="" class="table table-sm table-striped table-hover table-bordered border-dark">
                                        <thead>
                                            <tr class="bg-dark text-white">
                                                <th scope="col" rowspan="2"
                                                    class="border-dark text-center align-middle bg-info">#</th>
                                                <th scope="col" rowspan="2"
                                                    class="border-dark text-center align-middle bg-info">NIS</th>
                                                <th scope="col" rowspan="2"
                                                    class="border-dark text-center align-middle bg-info">Nama Siswa</th>
                                                <th scope="col" rowspan="2"
                                                    class="border-dark text-center align-middle bg-info">L/P</th>
                                                <th scope="col" rowspan="2"
                                                    class="border-dark text-center align-middle bg-info">Keterangan</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                          <?php $__currentLoopData = $siswa; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                              <td class="border-dark"><?php echo e($loop->iteration); ?></td>
                                              <td class="border-dark"><?php echo e($item->nis); ?></td>
                                              <td class="border-dark text-uppercase">
                                                <input type="hidden" name="siswa_id[]" value="<?php echo e($item->id); ?>">
                                                <?php echo e($item->name); ?>

                                              </td>
                                              <td class="border-dark text-uppercase">
                                                <?php echo e($item->jk); ?>

                                              </td>
                                              <td class="border-dark">
                                                <select name="keterangan[]" id="" class="form-control form-select">
                                                  
                                                </select>
                                              </td>
                                            </tr>

                                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                    <button type="submit" class="btn btn-success float-right">
                                      Simpan
                                  </button>
                                  <div class="checkbox float-right me-3">
                                      <label>
                                          <input type="checkbox" class="mt-3" required>
                                          Saya yakin akan mengubah data tersebut
                                      </label>
                                  </div>
                                  </form>
                                </div>
                            <?php endif; ?>
                        </div>
                        <!-- /.card-body -->
                    </div>
                </div>
            </div>

        </div>
    </section>

</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\project\absensi_walikelas\resources\views/pages/absensi2/kelolaabsen.blade.php ENDPATH**/ ?>