

<?php $__env->startSection('content'); ?>
    <?php
        use Carbon\Carbon;
    ?>

    <div class="content-header">
        <div class="container-fluid">

          <div class="row mb-0">
            <div class="col-sm-6">
                <h4 class="fw-bold poppins m-0">Data Sekolah</h4>
            </div>
            <div class="col-sm-6 mt-xs-2">
                <?php if(session()->has('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show mb-0" role="alert">
                        <?php echo $__env->make('_success', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php echo session('success'); ?>

                    </div>
                <?php endif; ?>
            </div>
          </div>

        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <?php if(!$sekolah): ?>
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header">
                                Tambah Data Sekolah
                            </div>
                            <div class="card-body">
                                <form action="<?php echo e(route('datasekolah.store')); ?>" method="POST">
                                    <?php echo csrf_field(); ?>

                                    <?php echo $__env->make('pages.datasekolah._addform', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                    
                                </form>
                            </div>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header">
                                Edit Data Sekolah
                            </div>
                            <div class="card-body">
                                <form action="<?php echo e(route('datasekolah.update', $sekolah->id)); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>

                                    <?php echo $__env->make('pages.datasekolah._editform', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                    
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header">
                                Edit Logo Sekolah
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-border table-hover mt-xs-2">

                                        <tr class="text-center table-secondary">
                                            <td>Logo</td>
                                        </tr>
                                        <tr>
                                            <td class="text-center"><img src="/img/<?php echo e($sekolah->logo); ?>" alt=""
                                                    style="width: 120px" class=""></td>
                                        </tr>
                                    </table>
                                </div>
                                <small class="fs-12"> <i>Ganti logo sekolah</i></small>
                                <form action="<?php echo e(route('logosekolah.update', $sekolah->id)); ?>" method="POST"
                                    enctype="multipart/form-data">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>

                                    <input type="hidden" name="old_logo" id="" value="<?php echo e($sekolah->logo); ?>"
                                        hidden>

                                    <div class="">
                                        <div class="my-2">
                                            <img class="img-preview img-fluid mb-2 col-sm-6 oferflow-y-hidden"
                                                style="max-width: 120px;">
                                        </div>
                                        <div class="input-group mb-3">
                                            <input type="file" accept="image/*"
                                                class="form-control <?php $__errorArgs = ['files'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="files"
                                                id="gambar" onchange="previewImage()">
                                            <button type="submit" class="input-group-text btn-primary"
                                                for="inputGroupFile02">Update</button>
                                            <?php $__errorArgs = ['files'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="invalid-feedback mt-1"><?php echo e($message); ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>

                                </form>
                            </div>
                        </div>
                    </div>
        <?php endif; ?>

            </div>

        </div>
    </section>

    <script>
        function previewImage() {
            const image = document.querySelector('#gambar');
            const imgPreview = document.querySelector('.img-preview');

            imgPreview.style.display = 'block';

            const oFReader = new FileReader();
            oFReader.readAsDataURL(gambar.files[0]);


            oFReader.onload = function(oFREvent) {
                imgPreview.src = oFREvent.target.result;
            }
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\project\smkn54kjt_absensi\resources\views/pages/datasekolah/index.blade.php ENDPATH**/ ?>