<?php
    use Carbon\Carbon;
?>

<?php $__env->startSection('css'); ?>
  <style>
    .vertical {
      transform: rotate(180deg);
    }
  </style>
<?php $__env->stopSection(); ?>



<?php $__env->startSection('content'); ?>
    <div class="content-header">
        <div class="container-fluid">

            <div class="row mb-0">
                <div class="col-sm-6">
                    <h4 class="fw-bold poppins m-0">
                      <a href="<?php echo e(route('absensi2.index', auth()->user()->role)); ?>" class="btn btn-sm btn-link p-0 me-1">
                        <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" fill="currentColor"
                            class="bi fw-bold bi-arrow-left" viewBox="0 0 16 16">
                            <path fill-rule="evenodd"
                                d="M15 8a.5.5 0 0 0-.5-.5H2.707l3.147-3.146a.5.5 0 1 0-.708-.708l-4 4a.5.5 0 0 0 0 .708l4 4a.5.5 0 0 0 .708-.708L2.707 8.5H14.5A.5.5 0 0 0 15 8z" />
                        </svg>
                    </a>
                      Absensi: <?php echo e($kelas->name); ?>

                    </h4>
                </div>
                <div class="col-sm-6">
                    <?php if(session()->has('success')): ?>
                        <div class="alert alert-success alert-dismissible fade show mb-0" role="alert">
                            <?php echo $__env->make('_success', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php echo session('success'); ?>

                        </div>
                    <?php endif; ?>
                </div>
            </div>

        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col">
                    <div class="card">
                        <div class="card-header">

                            <div class="callout callout-warning my-1">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="row">
                                            <div class="col-md-4 fw-bold">
                                                Kelas
                                            </div>
                                            <div class="col-md-8">
                                                : <?php echo e($kelas->name); ?>

                                            </div>
                                            <div class="col-md-4 fw-bold">
                                                Wali Kelas
                                            </div>
                                            <div class="col-md-8">
                                                : <?php echo e($kelas->guru->name); ?>

                                            </div>
                                            <div class="col-md-4 fw-bold">
                                                Tahun Pelajaran
                                            </div>
                                            <div class="col-md-8">
                                                : <?php echo e($kelas->tapel->tahun_pelajaran); ?> - Semester
                                                <?php echo e($kelas->tapel->semester); ?>

                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                      <div class="row">
                                          <div class="col-md-4 fw-bold">
                                            Bulan
                                        </div>
                                        <div class="col-md-8">
                                            : <?php echo e($monthIndo); ?>

                                        </div>
                                      </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card-body">

                          <div class="table-responsive">
                            <table class="table table-sm table-hover table-bordered border-dark">

                              <thead>
                                <tr class="border-dark">
                                  <th class="border-dark text-center align-middle bg-info" rowspan="2">#</th>
                                  <th class="border-dark text-center align-middle bg-info" rowspan="2" style="min-width: 200px">Nama Siswa</th>
                                  <th class="border-dark text-center align-middle bg-info" rowspan="2">NIS</th>
                                  <th class="border-dark text-center align-middle bg-info" rowspan="2">L/P</th>
                                  <th class="border-dark text-center align-middle bg-info" colspan="<?php echo e(count($months)); ?>">Tanggal</th>
                                  <th class="border-dark text-center align-middle bg-info" colspan="4" >Jumlah</th>
                                </tr>
                                <tr class="bg-secondary">
                                  <?php $__currentLoopData = $months; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $bulan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if(Str::before(Carbon::parse($bulan)->locale('id_ID')->isoFormat('dddd, D MMMM Y'), ',') == 'Minggu'): ?>
                                    <th class="border-dark text-center disabled" data-bs-toggle="tooltip"
                                      data-bs-placement="top" title="<?php echo e(Carbon::parse($bulan)->locale('id_ID')->isoFormat('dddd, D MMMM Y')); ?>">
                                      <?php echo e(Str::afterLast($bulan, '-')); ?>

                                    </th>
                                    <?php else: ?>
                                      <th class="border-dark text-center" data-bs-toggle="tooltip"
                                        data-bs-placement="top" title="<?php echo e(Carbon::parse($bulan)->locale('id_ID')->isoFormat('dddd, D MMMM Y')); ?>">
                                        <a href="<?php echo e(route('absensi.kelas.day', [$role,  $kelas->id, $month, $bulan])); ?>">
                                          <?php echo e(Str::afterLast($bulan, '-')); ?>

                                        </a>
                                      </th>
                                    <?php endif; ?>
                                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                  <th class="bg-success border-dark align-middle text-center" style="min-width: 30px">H</th>
                                  <th class="bg-primary border-dark align-middle text-center" style="min-width: 30px">S</th>
                                  <th class="bg-warning border-dark align-middle text-center" style="min-width: 30px">I</th>
                                  <th class="bg-danger border-dark align-middle text-center" style="min-width: 30px">A</th>
                                </tr>
                              </thead>
                              <tbody>
                                <?php $__currentLoopData = $siswa; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="border-dark">
                                      <td class="border-dark"><?php echo e($index); ?></td>
                                      <td class="border-dark">Elfan Hari Saputra</td>
                                      <td class="border-dark">90235323</td>
                                      <td class="border-dark">L</td>
                                      <?php $__currentLoopData = $months; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bulan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                          <?php if(Carbon::parse($bulan)->isoFormat('dddd') == 'Sabtu' || Carbon::parse($bulan)->isoFormat('dddd') == 'Minggu'): ?>
                                              <td class="border-dark bg-danger">
                                                 LIBUR
                                              </td>
                                          <?php else: ?>
                                              <td class="border-dark">
                                                  <span class="badge bg-secondary px-2">Belum <br> Diinput</span>
                                              </td>
                                          <?php endif; ?>
                                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                      <td class="border-dark">28</td>
                                      <td class="border-dark">0</td>
                                      <td class="border-dark">0</td>
                                      <td class="border-dark">0</td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                              </tbody>

                            </table>
                          </div>

                        </div>

                    </div>
                </div>
            </div>
        </div>

        </div>
    </section>

    <script>
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
        var tooltipList = tooltipTriggerList.map(function(tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl)
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\project\absensi_walikelas\resources\views/pages/absensi2/showmonth.blade.php ENDPATH**/ ?>